﻿using System;

namespace DocumentProcessing
{
    // Listing 5-22. Rejestracja oraz rezygnacja z subskrypcji zdarzeń
    class ProductionDeptTool1
    {
        public void Subscribe(DocumentProcessor processor)
        {
            processor.Processing += processor_Processing;
            processor.Processed += processor_Processed;
        }

        public void Unsubscribe(DocumentProcessor processor)
        {
            processor.Processing -= processor_Processing;
            processor.Processed -= processor_Processed;
        }

        void processor_Processing(object sender, EventArgs e)
        {
            Console.WriteLine("Narzędzie 1. - zarejestrowano przetwarzanie.");
        }

        void processor_Processed(object sender, EventArgs e)
        {
            Console.WriteLine("Narzędzie 1. - zarejestrowano zakończenie przetwarzania.");
        }
    }

    class ProductionDeptTool2
    {
        public void Subscribe(DocumentProcessor processor)
        {
            processor.Processing +=
                (sender, e) => Console.WriteLine("Narzędzie 2. - zarejestrowano przetwarzanie.");
            processor.Processed +=
                (sender, e) =>
                   Console.WriteLine("Narzędzie 2. - zarejestrowano zakończenie przetwarzania.");
        }
    }
}
